<?php

/**
 * @author Stichting WebwinkelKeur
 * @copyright 2014
 * Helper class to send review
 */
class ReviewInvite extends Exception {
	public function ReviewInvite($shop_id, $apikey, $order_id, $email, $delay=0, $noremail=0) {
		$sBaseUrl = "https://www.webwinkelkeur.nl";
		//Define parameters
		$parameters = array(
		'id'        => $shop_id,
		'password'  => $apikey,
		'email'     => $email,
		'order'     => $order_id,
		'delay'     => $delay,
		'noremail'  => $noremail
		);
		//Build url
		$url = $sBaseUrl.'/api.php?'.http_build_query($parameters);
		//Get Response
		$response = $this->retrieve($url);
		if(!$response) {
			throw new APIError($url, 'API not reachable.');
		} elseif(preg_match('|^\s*Success:|', $response)) {
			return true;
		} elseif(preg_match('|invite already sent|', $response)) {
			throw new APIAlreadySentError($url, $response);
		} else {
			throw new APIError($url, $response);
		}
	}
	private function retrieve($url) {
		if(($content = $this->retrieveWithCURL($url)) !== false) {
	 		return $content;
		} elseif(($content = $this->retrieveWithFile($url)) !== false) {
	        return $content;
		} else {
	    	return false;
		}
	}
	private function retrieveWithCURL($url) {
		if(!function_exists('curl_init')) {
	    	return false;
	     }
	     if(!($curl = @curl_init($url))) {
	     	return false;
	     }
	     //Works to overcome SSL dificulties, set to true for optimal security!
	     curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
	     if(!@curl_setopt($curl, CURLOPT_RETURNTRANSFER, true)) {
	     	return false;
	     }
	     return @curl_exec($curl);
	}

	private function retrieveWithFile($url) {
	        return @file_get_contents($url);
	}
}
class APIError extends Exception {
    private $url;
    public function __construct($url, $message) {
        $this->url = $url;
        parent::__construct($message);
    }
    public function getURL() {
        return $this->url;
    }
}
class APIAlreadySentError extends APIError {}
?>